package nemosofts.voxradio.executor;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;

import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.interfaces.RadioListener;
import nemosofts.voxradio.item.ItemRadio;
import nemosofts.voxradio.utils.ApplicationUtil;
import nemosofts.voxradio.utils.AsyncTaskExecutor;
import okhttp3.RequestBody;

public class LoadRadio extends AsyncTaskExecutor<String, String, String> {

    private final RadioListener songsListener;
    private final ArrayList<ItemRadio> arrayList = new ArrayList<>();
    private final RequestBody requestBody;
    private String verifyStatus = "0";
    private String message = "";

    public LoadRadio(RadioListener songsListener, RequestBody requestBody) {
        this.songsListener = songsListener;
        this.requestBody = requestBody;
    }

    @Override
    protected void onPreExecute() {
        songsListener.onStart();
        super.onPreExecute();
    }

    @Override
    protected  String doInBackground(String strings)  {
        String json = ApplicationUtil.responsePost(Callback.API_URL, requestBody);
        try {
            JSONObject jOb = new JSONObject(json);
            JSONArray jsonArray = jOb.getJSONArray(Callback.TAG_ROOT);

            for (int i = 0; i < jsonArray.length(); i++) {
                JSONObject objJson = jsonArray.getJSONObject(i);

                if (!objJson.has(Callback.TAG_SUCCESS)) {

                    String id = objJson.getString("id");
                    String catId = objJson.getString("cat_id");
                    String radioTitle = objJson.getString("radio_title");
                    String radioURL = objJson.getString("radio_url");
                    String image = objJson.getString("image").replace(" ", "%20");
                    if (image.isEmpty()) {
                        image = "null";
                    }
                    String averageRating = objJson.getString("averageRating");
                    String totalRate = objJson.getString("totalRate");
                    String catName = objJson.getString("category_name");
                    String totalViews = objJson.getString("total_views");
                    boolean isPremium = objJson.getBoolean("is_premium");
                    boolean isFav = objJson.getBoolean("is_favourite");

                    ItemRadio objItem = new ItemRadio(id, catId, radioTitle, radioURL, image,
                            averageRating, totalRate, totalViews, catName, isPremium, isFav);
                    arrayList.add(objItem);

                } else {
                    verifyStatus = objJson.getString(Callback.TAG_SUCCESS);
                    message = objJson.getString(Callback.TAG_MSG);
                }
            }
            return "1";
        } catch (Exception e) {
            return "0";
        }
    }

    @Override
    protected void onPostExecute(String s) {
        songsListener.onEnd(s, verifyStatus, message, arrayList);
    }
}

